define(['modules/new-appointment-request/resources/common/type-of-care/collection'], function(Collection) {
    'use strict';


    describe('Types of Care Collection', function() {
        var collection;

        beforeEach(function() {
            collection = new Collection();
        });
        it('creates the correct url', function() {
            var url = 'base-url/VeteranAppointmentRequestService/v4/rest/clinical-services/types-of-care';
            expect(collection.url()).toBe(url);
        });

        it('sorts the models correctly', function() {
            var data = [
                {
                    id: '1',
                    name: 'BAC',
                },
                {
                    id: '2',
                    name: 'CBA',
                },
                {
                    id: '3',
                    name: 'ABC',
                },
            ];
            collection.set(data);
            expect(collection.at(0).get('name')).toBe(data[2].name);
            expect(collection.at(1).get('name')).toBe(data[0].name);
            expect(collection.at(2).get('name')).toBe(data[1].name);
        });

        it('puts primary care on top of the sort', function() {

            var data = [
                {
                    id: '1',
                    name: 'BAC',
                },
                {
                    id: '323',
                    name: 'Primary Care',
                },
                {
                    id: '2',
                    name: 'CBA',
                },
                {
                    id: '3',
                    name: 'ABC',
                },
            ];
            collection.set(data);
            expect(collection.at(0).get('name')).toBe(data[1].name);
            expect(collection.at(1).get('name')).toBe(data[3].name);
            expect(collection.at(2).get('name')).toBe(data[0].name);
            expect(collection.at(3).get('name')).toBe(data[2].name);
        });
    });
});
